

export class ArticleSearchPopup {
	
	
	
	tpl = `
		<div class="article-search-popup">
			<div class="page-header">
				<div class="toolbox">
					<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				</div>
				<h1>Artikel zoeken</h1>
			</div>
	
			<div>
				<input type="text" name="q" class="q-top" placeholder="Zoeken..." />
			</div>
			
			<div ez-subtemplate="articles">
				<table class="table">
					<thead>
						<tr>
							<th>Artikelnaam</th>
							<th>Verhuur</th>
							<th style="width: 250px;">Prijs</th>
						</tr>
					</thead>
					
					<tbody ez-for="articles" ez-item="a">
						<tr [widget]="widget" [article]="a" onclick="widget.selectArticle(this);" class="article-price-count-{{ a.pricingMethod == 'slotplan' ? a.slotplanPrices.length : 1 }}">
							<td>{{ a.shortDescription }}</td>
							<td>{{ a.rentable ? 'Ja' : 'Nee' }}</td>
							<td>
								<span ez-if="a.pricingMethod != 'slotplan'">
									<div class="btn-article-price">
										{{ a.displayPrice }}
										-
										{{ _('pricingmethod.'+a.pricingMethod??'') }}
									</div>
								</span>
								
								<div ez-if="a.pricingMethod == 'slotplan'">
									<div ez-for="a.slotplanPrices" ez-item="spp">
										<div class="btn-article-price" [widget]="widget" [article]="a" [spp]="spp" onclick="widget.selectArticle(this);">
											{{ spp.displayPrice }} - {{spp.slotplanPricetypeName}}
										</div>
									</div>
								
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	`;
	
	
	articles = null;
	response = null;
	
	popup = null;
	callback_select_article = null;
	
	
	setSelectArticle( func ) { this.callback_select_article = func; }
	
	searchArticles() {
		
		postUrl('/service/sales/article.do', {
			a: 'search',
			q: $('.article-search-popup .q-top').val()
		}).then( async function(e) {
			let json = await e.json();
			
			this.articles = json.articles;
			this.response = json;
			
			this.ezTpl.setVar('articles', this.articles);
			this.ezTpl.setVar('response', json);
			this.ezTpl.renderSubTemplate( 'articles' );
		}.bind(this) );
		
	}
	
	close() {
		close_popup();
	}
	
	selectArticle( obj ) {
		let evt = window.event;
		evt.stopPropagation();
		
		let article = obj.article;
		let slotplan = obj.spp;
		
//		console.log('article', article);
//		console.log('slotplan', slotplan);
		
		if ( article.pricingMethod == 'slotplan' && $(evt.target).hasClass('btn-article-price') == false ) {
			showToastMessage( 'Kies een prijs' );
			return;
		}
		
//		console.log( article );
		article.selectedSlotplan = slotplan;
		if (slotplan) {
			article.line_description = article.shortDescription +  ' / ' + slotplan.slotplanPricetypeName;
			article.line_price_excl_vat = slotplan.priceExclVat;
			article.line_price_incl_vat = slotplan.priceInclVat;
		}
		else {
			article.line_description = article.shortDescription;
			article.line_price_excl_vat = article.priceExclVat;
			article.line_price_incl_vat = article.priceInclVat;
		}
		
		if ( this.callback_select_article )
			this.callback_select_article( article );
		close_popup();
	}
	
	render() {
		if (this.popup == null)
			this.popup = show_popup( 'Artikel opzoeken' );
		
		this.ezTpl = new EzTemplate( this.popup );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setObject( 'widget', this );
		this.ezTpl.setVar('articles', this.articles);
		this.ezTpl.setVar('response', this.response);
		this.ezTpl.render();
		
		$('.article-search-popup .q-top').on('change', function() { this.searchArticles(); }.bind(this));
	}
	
	
	show() {
		this.render();
		
		this.searchArticles();
	}
	
	
}



